/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.transformer;

import com.blamejared.crafttweaker.api.ingredient.transformer.IIngredientTransformer;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class IngredientTransformers
implements UnaryOperator<IItemStack> {
    public static final Codec<IngredientTransformers> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IIngredientTransformer.CODEC.listOf().fieldOf("transformers").forGetter(IngredientTransformers::transformers)).apply((Applicative)instance, IngredientTransformers::new));
    public static final class_9139<class_9129, IngredientTransformers> STREAM_CODEC = class_9139.method_56434((class_9139)IIngredientTransformer.STREAM_CODEC.method_56433(class_9135.method_56363()), IngredientTransformers::transformers, IngredientTransformers::new);
    public static final IngredientTransformers EMPTY = new IngredientTransformers();
    private final List<IIngredientTransformer> transformers;
    private final List<IIngredientTransformer> transformersView;

    public IngredientTransformers() {
        this(new ArrayList<IIngredientTransformer>());
    }

    public IngredientTransformers(List<IIngredientTransformer> transformers) {
        this.transformers = transformers;
        this.transformersView = Collections.unmodifiableList(this.transformers);
    }

    public IngredientTransformers copy() {
        return new IngredientTransformers(new ArrayList<IIngredientTransformer>(this.transformersView));
    }

    public boolean isEmpty() {
        return this == EMPTY || this.transformers().isEmpty();
    }

    public void add(IIngredientTransformer transformer) {
        if (this == EMPTY) {
            throw new UnsupportedOperationException("Unable to add '" + String.valueOf(transformer) + "' to an empty transformer!");
        }
        this.transformers.add(transformer);
    }

    public List<IIngredientTransformer> transformers() {
        return this.transformersView;
    }

    @Override
    public IItemStack apply(IItemStack in) {
        return this.transformers().stream().reduce(in.asImmutable(), (stack, transformer) -> transformer.transform((IItemStack)stack), (a, b) -> b);
    }

    public String getCommandString(String base) {
        return this.transformers().stream().map(iIngredientTransformer -> iIngredientTransformer.getCommandString(base)).collect(Collectors.joining());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngredientTransformers that = (IngredientTransformers)o;
        return Objects.equals(this.transformers, that.transformers) && Objects.equals(this.transformersView, that.transformersView);
    }

    public int hashCode() {
        return Objects.hash(this.transformers, this.transformersView);
    }
}

